// Enemy.js //

var EnemySS = LoadSpriteset("Enemies.rss");
var Enemies = [];

function Enemy()
{
	var image = Math.floor(Math.random()*4);
	this.x = Game.level.start.x; this.y = Game.level.start.y;
	this.hp = Game.ehp;
	this.maxHp = Game.ehp;
	this.money = Game.emoney;
	this.flying = (image == 3);
	this.s = (this.flying) ? Game.espd*1.20 : Game.espd;
	this.offset = (this.flying) ? 32 : 0;
	this.img = EnemySS.images[image];
	this.point = 0;
	this.waypoint = Game.level.moves[0]; 
	this.a = Math.PI;
	this.onEnd = function() {};
	this.updateAngle();
	this.dead = false;
	this.vx = Math.cos(this.a) * this.s;
	this.vy = Math.sin(this.a) * this.s;
}

Enemy.prototype.updateAngle = function()
{
	this.a = Math.atan2((this.waypoint.y*16)-this.y, (this.waypoint.x*16)-this.x);
	this.vx = Math.cos(this.a) * this.s;
	this.vy = Math.sin(this.a) * this.s;
}

Enemy.prototype.update = function()
{
	sx = MapToScreenX(0, this.x);
	sy = MapToScreenY(0, this.y-this.offset);
	this.img.rotateBlit(sx, sy, this.a);
	if (this.flying) this.img.rotateBlitMask(sx, sy+this.offset, this.a, T_Black);
	var w = this.hp/this.maxHp * 16;
	if (this.hp > ((this.maxHp * 3) >> 2)) Rectangle(sx, sy, w, 2, Colors.green);
	else if (this.hp > (this.maxHp >> 1)) Rectangle(sx, sy, w, 2, Colors.yellow);
	else if (this.hp > (this.maxHp >> 2)) Rectangle(sx, sy, w, 2, Colors.orange);
	else Rectangle(sx, sy, w, 2, Colors.red);
	OutlinedRectangle(sx-1, sy-1, 18, 4, Colors.black);

	this.x += this.vx;
	this.y += this.vy;
	
	if (this.x > 0 && this.y > 0 && this.x < Game.layerWidth && this.y < Game.layerHeight && !this.flying)
	{
		if (GetTileName(GetTile(this.x/16, this.y/16, 0)) == "mud") this.s = 0.25;
		else this.resetSpeed();
	}
	
	if (this.hp <= 0) { Game.mana++; Enemies.splice(Enemies.indexOf(this), 1); this.dead = true; }
	
	if (Math.round(this.x) == this.waypoint.x*16 && Math.round(this.y) == this.waypoint.y*16)
	{
		if (this.point == Game.level.moves.length-1) this.onEnd();
		else
		{
			this.point++;
			this.waypoint = Game.level.moves[this.point];
			this.updateAngle();
		}
	}
}

Enemy.prototype.resetSpeed = function()
{
	if (this.s == Game.espd) return;
	this.s = Game.espd;
	this.x = Math.round(this.x);
	this.y = Math.round(this.y);
}

function CreateEnemy()
{
	var enemy = new Enemy();
	enemy.onEnd = function(){ Game.life--; Enemies.splice(Enemies.indexOf(this), 1); };
	Enemies.push(enemy);
	Game.waves[Game.level.wave].enemies++;
}

function UpdateEnemies()
{
	var i = Enemies.length;
	while(i--) Enemies[i].update();
}